# Автор: Л. Шастин

'''
В файле 17-10.txt содержится последовательность целых чисел. Элементы последовательности могут принимать значения от 0 до 10000 включительно.
Определите сначала количество пар, сумма элементов в которых, при переводе в систему счисления с основанием 7, образует палиндромическое
число, а затем наибольшую сумму-палиндром в семеричной системе счисления. Под парой чисел подразумевается два идущих подряд элемента последовательности.
'''

#Решение:

def sys7(palindrom): #Функция для перевода числа в 7-ричную систему счисления
	strok = ''
	while palindrom>0:
		palindrom, a = divmod(palindrom, 7)
		strok+=str(a)
	return strok

def is_palindrom(summ): #Функция для проверки, является ли сумма, переведённая в 7-ричную систему счисления палиндромом
	result1, result2 = [], []
	while summ>0:
		summ, el = divmod (summ, 7)
		result1 = [el] + result1
		result2 += [el]
	return result1 == result2

f = list(map(int, open('17-10.txt'))) #Образуем список из целочисленных элементов в открытом файлике 17-10.txt
summs = [f[x]+f[x+1] for x in range(len(f)-1) if is_palindrom(f[x]+f[x+1])] #Генерируем суммы по определённым условиям
palindromes = [sys7(palindrom) for palindrom in summs] #Переводим сгенерированные суммы в 7-ричную СС
print(len(summs), max(map(int, palindromes))) #Выводим ответ - количество подходящих сумм, наибольшую сумму-палиндром

#Ответ: 243 25552
