"""
Автор: О. Лысенков

(О. Лысенков) На вход алгоритма подается целое неотрицательное число N. Алгоритм строит по нему новое число R по следующему правилу:
1) Число  N переводится в 30-ричную систему счисления.
2) Считается сумма значений цифр данного числа в 30-ричной системе счисления.
3) Сумма умножается на числовое значение последней десятичной цифры числа N.
Число R - это результат выполнения п. 3.

Найдите количество чисел N, меньших 10^7, при которых
значение R кратно хотя бы одному простому числу, не равному R.

Примечание: 1 - не простое число.

Ответ: 9771349
"""
def toBase30( N ):
  N30 = []
  while N:
    N30 = [N%30] + N30
    N //= 30
  return N30

def alg( N ):
  N30 = toBase30( N )
  R = sum(N30) * (N % 10)
  return R

def valid( R ):
  if R < 2: return True
  if R == 2: return False
  for d in range(2,round(R**0.5)+1):
    if R % d == 0: return True
  return False

print( sum(1 for N in range(10**7)
             if valid(alg(N)) ) )

