<?php
session_start();

// --- Настройки капчи ---
$width = 70; // Увеличиваем ширину для лучшей читаемости
$height = 30; // Увеличиваем высоту
$num_chars = rand(4, 4); // Случайное количество символов от 5 до 7
// Расширенный набор символов: цифры и заглавные/строчные буквы (исключены похожие: O, 0, I, l)
$chars = '123456789'; 
// --- Конец настроек ---

// Генерация кода капчи
$captcha_code = substr(str_shuffle($chars), 0, $num_chars);
$_SESSION['captcha'] = $captcha_code;

// Создание изображения
$image = imagecreatetruecolor($width, $height);

// Цвета
// Более случайные и разнообразные цвета для фона, текста и шума
$background = imagecolorallocate($image, rand(255, 255), rand(255, 255), rand(255, 255)); // Светлый случайный фон
$text_color = imagecolorallocate($image, rand(0, 50), rand(0, 50), rand(0, 50));     // Тёмный случайный цвет текста
$line_color = imagecolorallocate($image, rand(120, 200), rand(120, 200), rand(120, 200)); // Средний случайный цвет линий
$dot_color = imagecolorallocate($image, rand(80, 150), rand(80, 150), rand(80, 150));     // Средний случайный цвет точек

// Заливка фона
imagefilledrectangle($image, 0, 0, $width, $height, $background);

// Добавление шума (линий) - увеличиваем количество




// Выводим текст капчи (шрифт встроенный — размер от 1 до 5)
$font_size = 5; 
$char_width = imagefontwidth($font_size);
$char_height = imagefontheight($font_size);

// Случайное смещение для начальной позиции текста по X
$x_offset = rand(8, 8);
// Случайное смещение для начальной позиции текста по Y
$y_offset = rand(5, 5);

// Выводим каждый символ отдельно со случайным небольшим смещением
for ($i = 0; $i < strlen($captcha_code); $i++) {
    $char = $captcha_code[$i];
    imagestring($image, $font_size, $x_offset, $y_offset + rand(1, 1), $char, $text_color);
    $x_offset += $char_width + rand(1, 1); // Случайный интервал между символами
}


// Добавление случайных эллипсов/дуг для дополнительного шума


// Отправка изображения
header('Content-Type: image/png');
imagepng($image);
imagedestroy($image);

// Не закрываем PHP тег чтобы избежать случайных пробелов в конце файла