<?php
// Включаем сессии, если они еще не включены
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Конфигурация для Dudu2.id
define('AUTH_API_URL', 'https://oauth.dudu2.ru/index.php?page=api');
define('AUTH_LOGIN_URL', 'https://oauth.dudu2.ru/index.php?page=login');
define('SITE_URL', 'тут_адрес_сайта_гостевой'); // !!! ЗАМЕНИТЕ НА РЕАЛЬНЫЙ URL ВАШЕГО САЙТА !!!
define('COOKIE_NAME', 'dudu2_auth_token'); // Имя cookie для хранения токена
define('COOKIE_EXPIRE', time() + (30 * 24 * 60 * 60)); // Срок действия cookie - 30 дней

// Функция для проверки авторизации через API
function checkAuth($api_token) {
    $url = AUTH_API_URL . '&api_token=' . urlencode($api_token);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Для работы с SSL на некоторых хостингах может потребоваться отключить проверку сертификата
    // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code === 200 && $response) {
        $data = json_decode($response, true);
        // Добавлена проверка, чтобы убедиться, что $data является массивом и содержит ключ 'status'
        if (is_array($data) && isset($data['status']) && $data['status'] === 'success') {
            return $data['user'];
        }
    }
    return false;
}

// Функция для установки cookie с токеном
function setAuthCookie($api_token) {
    setcookie(COOKIE_NAME, $api_token, COOKIE_EXPIRE, '/', '', true, true); // secure и httponly
}

// Функция для удаления cookie
function clearAuthCookie() {
    setcookie(COOKIE_NAME, '', time() - 3600, '/', '', true, true);
}

// Переменные для хранения информации о пользователе и ошибках авторизации
$dudu2_user = null;
$dudu2_auth_errors = [];
$dudu2_auth_success = '';

// Обработка возврата с сервиса авторизации
if (isset($_GET['api_token'])) {
    $api_token = trim($_GET['api_token']);
    $user_data = checkAuth($api_token);
    if ($user_data) {
        $_SESSION['dudu2_user'] = $user_data;
        $_SESSION['dudu2_api_token'] = $api_token;
        setAuthCookie($api_token); // Устанавливаем cookie с токеном
        $dudu2_user = $user_data;
        $dudu2_auth_success = 'Вы успешно авторизованы через Dudu2.id!';
        // Перенаправляем, чтобы убрать api_token из URL
        header('Location: ' . SITE_URL);
        exit;
    } else {
        $dudu2_auth_errors[] = 'Неверный API-токен или неподтвержденный email.';
    }
}

// Проверка авторизации через сессию
if (isset($_SESSION['dudu2_api_token']) && !$dudu2_user) {
    $user_data = checkAuth($_SESSION['dudu2_api_token']);
    if ($user_data) {
        $_SESSION['dudu2_user'] = $user_data; // Обновляем данные пользователя в сессии
        $dudu2_user = $user_data;
    } else {
        // Если токен невалиден, очищаем сессию
        unset($_SESSION['dudu2_user'], $_SESSION['dudu2_api_token']);
        $dudu2_auth_errors[] = 'Ваша сессия Dudu2.id устарела или недействительна. Пожалуйста, войдите снова.';
    }
}

// Если сессия истекла, но есть cookie с токеном, пробуем авторизоваться через cookie
if (!$dudu2_user && isset($_COOKIE[COOKIE_NAME])) {
    $api_token = $_COOKIE[COOKIE_NAME];
    $user_data = checkAuth($api_token);
    if ($user_data) {
        $_SESSION['dudu2_user'] = $user_data;
        $_SESSION['dudu2_api_token'] = $api_token;
        $dudu2_user = $user_data;
        // Продлеваем cookie
        setAuthCookie($api_token);
    } else {
        // Если токен в cookie невалиден, удаляем cookie
        clearAuthCookie();
        $dudu2_auth_errors[] = 'Ваша сессия Dudu2.id устарела или недействительна. Пожалуйста, войдите снова.';
    }
}

// Выход из Dudu2.id авторизации
if (isset($_GET['action']) && $_GET['action'] === 'dudu2_logout') {
    unset($_SESSION['dudu2_user'], $_SESSION['dudu2_api_token']);
    clearAuthCookie(); // Удаляем cookie при выходе
    header("Location: " . SITE_URL);
    exit;
}
?>