function sendHeight() {
let height = document.body.scrollHeight;
parent.postMessage(height, "*");
}
window.onload = sendHeight;
window.onresize = sendHeight;
function toggleReplyForm(messageId) {
const replyFormContainer = document.getElementById('reply-form-container-' + messageId);
if (replyFormContainer) {
if (replyFormContainer.style.display === 'block') {
replyFormContainer.style.display = 'none';
const form = replyFormContainer.querySelector('form');
if (form) {
form.reset();
const captchaImg = form.querySelector('.captcha-img');
if (captchaImg) {
captchaImg.src = 'captcha.php?_t=' + new Date().getTime();
}
}
} else {
document.querySelectorAll('.reply-form-container').forEach(form => {
if (form.id !== 'reply-form-container-' + messageId) {
form.style.display = 'none';
const otherForm = form.querySelector('form');
if (otherForm) {
otherForm.reset();
const captchaImg = otherForm.querySelector('.captcha-img');
if (captchaImg) {
captchaImg.src = 'captcha.php?_t=' + new Date().getTime();
}
}
}
});
replyFormContainer.style.display = 'block';
const nameField = document.getElementById('reply-name-' + messageId);
if (nameField) {
nameField.focus();
}
const captchaImg = replyFormContainer.querySelector('.captcha-img');
if (captchaImg) {
captchaImg.src = 'captcha.php?_t=' + new Date().getTime();
}
replyFormContainer.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
}
}
}
function insertTag(tag, textareaId = "message") {
let textarea = document.getElementById(textareaId);
if (!textarea) return;
let start = textarea.selectionStart;
let end = textarea.selectionEnd;
let selectedText = textarea.value.substring(start, end);
let before = textarea.value.substring(0, start);
let after = textarea.value.substring(end, textarea.value.length);
let newText;
if (tag === 'a') {
let url = prompt('Введите URL ссылки:', 'http://');
if (url) {
newText = before + '<a href="' + url + '">' + (selectedText || 'текст ссылки') + '</a>' + after;
} else {
return;
}
} else if (tag === 'br') {
newText = before + '<br>' + after;
} else if (tag === 'ul' || tag === 'ol') {
newText = before + '<' + tag + '>\n' + (selectedText || '<li>Пункт 1</li>\n<li>Пункт 2</li>') + '\n</' + tag + '>' + after;
} else if (tag === 'li') {
newText = before + '<li>' + (selectedText || 'Пункт') + '</li>' + after;
}
else {
newText = before + '<' + tag + '>' + selectedText + '</' + tag + '>' + after;
}
textarea.value = newText;
textarea.selectionStart = textarea.selectionEnd = start + newText.length - (after.length + tag.length + 3);
textarea.focus();
}
document.addEventListener("DOMContentLoaded", function () {
let messageBox = document.getElementById("message");
if (messageBox) {
messageBox.addEventListener("keydown", function (event) {
if (event.key === "Enter" && !event.shiftKey) {
event.preventDefault();
let start = this.selectionStart;
let end = this.selectionEnd;
this.value = this.value.substring(0, start) + "<br>" + this.value.substring(end);
this.selectionStart = this.selectionEnd = start + 4;
}
});
}
const replyErrorParentId = <?= json_encode($reply_error_parent_id) ?>;
if (replyErrorParentId) {
toggleReplyForm(replyErrorParentId);
}
<?php if ($editing_message_id): ?>
document.getElementById('guestbook-form-id').scrollIntoView({ behavior: 'smooth', block: 'nearest' });
<?php endif; ?>
});