<?php
session_start();
// Подключаем авторизацию
require_once 'dudu2_auth.php';

// Настройки БД
$host = 'localhost';
$db = 'база_данных';
$user = 'логин_пользователя_DB';
$pass = 'пароль_пользователя_DB';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
PDO::ATTR_EMULATE_PREPARES => false,
];

try {
$pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
die('Ошибка подключения к базе данных: ' . $e->getMessage());
}

// Проверяем, является ли пользователь админом
$is_admin = ($dudu2_user && (isset($dudu2_user['login']) && $dudu2_user['login'] === 'admin')); // логин админа гостевой в системе dudu2.Id
// Месяц в секундах для проверки прав редактирования пользователем
$one_month_in_seconds = 30 * 24 * 60 * 60;

// Инициализация переменных формы
$name = '';
if ($dudu2_user) {
if (empty($dudu2_user['name'])) {
$name = 'Пришелец' . rand(10000, 99999);
} else {
$name = $dudu2_user['name'];
}
} else {
$name = '';
}

$email = $dudu2_user['email'] ?? '';
$city = '';
$website = '';
$message_content = '';
$replyTo = null;
$captcha = '';

$editing_message_id = null;
$editing_message_data = [];

// --- ЛОГИКА УДАЛЕНИЯ ---
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
$message_id_to_delete = (int)$_GET['id'];
$can_delete = false;

if ($is_admin) {
$can_delete = true;
} elseif ($dudu2_user) {
// Проверяем, принадлежит ли сообщение пользователю
$stmt_check = $pdo->prepare("SELECT email, created_at FROM guestbook WHERE id = ? LIMIT 1");
$stmt_check->execute([$message_id_to_delete]);
$message_info = $stmt_check->fetch(PDO::FETCH_ASSOC);

if ($message_info && $message_info['email'] === $dudu2_user['email']) {
$message_timestamp = strtotime($message_info['created_at']);
if ($message_timestamp >= (time() - $one_month_in_seconds)) {
$can_delete = true;
}
}
}

if ($can_delete) {
try {
// Сначала удаляем ответы
$stmt_delete_replies = $pdo->prepare("DELETE FROM guestbook WHERE reply_to = ?");
$stmt_delete_replies->execute([$message_id_to_delete]);

// Удаляем само сообщение
$stmt_delete_message = $pdo->prepare("DELETE FROM guestbook WHERE id = ?");
$stmt_delete_message->execute([$message_id_to_delete]);

$_SESSION['main_form_success'] = 'Сообщение удалено.';
} catch (\PDOException $e) {
$_SESSION['main_form_error'] = 'Ошибка при удалении: ' . $e->getMessage();
}
} else {
$_SESSION['main_form_error'] = 'Нет прав или истек срок.';
}
header('Location: index.php');
exit;
}

// --- ЛОГИКА ПОДГОТОВКИ К РЕДАКТИРОВАНИЮ (GET) ---
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['id'])) {
$editing_message_id = (int)$_GET['id'];
$can_edit = false;

$stmt_edit = $pdo->prepare("SELECT * FROM guestbook WHERE id = ? LIMIT 1");
$stmt_edit->execute([$editing_message_id]);
$editing_message_data = $stmt_edit->fetch(PDO::FETCH_ASSOC);

if ($editing_message_data) {
if ($is_admin) {
$can_edit = true;
} elseif ($dudu2_user && $editing_message_data['email'] === $dudu2_user['email']) {
$message_timestamp = strtotime($editing_message_data['created_at']);
if ($message_timestamp >= (time() - $one_month_in_seconds)) {
$can_edit = true;
}
}
}

if ($can_edit) {
// Заполняем форму данными из базы
$name = $editing_message_data['name'];
$email = $editing_message_data['email'];
$city = $editing_message_data['city'];
$website = $editing_message_data['website'];
$message_content = $editing_message_data['message'];
$replyTo = $editing_message_data['reply_to'];
$_SESSION['main_form_success'] = 'Редактирование сообщения #' . $editing_message_id;
} else {
$_SESSION['main_form_error'] = 'Сообщение не найдено или нет прав.';
header('Location: index.php');
exit;
}
}

// --- ОБРАБОТКА ОТПРАВКИ ФОРМЫ (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
$is_reply_form = isset($_POST['is_reply_form']) && $_POST['is_reply_form'] == '1';

// Получаем данные из формы или сессии пользователя
if ($dudu2_user) {
if (empty($dudu2_user['name'])) {
$name = 'Пришелец' . rand(10000, 99999);
} else {
$name = $dudu2_user['name'];
}
$email = $dudu2_user['email'];
} else {
$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
}

$city = trim($_POST['city'] ?? '');
$website = trim($_POST['website'] ?? '');
$message_content = trim($_POST['message'] ?? '');
$captcha = $_POST['captcha'] ?? '';

$replyTo = !empty($_POST['reply_to']) ? (int)$_POST['reply_to'] : null;
$message_id = $_POST['message_id'] ?? null;

$errors = [];

// Проверка: отвечать может только админ
if ($replyTo && !$is_admin) {
$errors[] = 'Отвечать на сообщения может только администратор.';
}

// Проверка капчи для неавторизованных
if (!$dudu2_user) {
if (!isset($_SESSION['captcha']) || strtolower($captcha) !== strtolower($_SESSION['captcha'])) {
$errors[] = 'Неверный код с картинки.';
} else {
unset($_SESSION['captcha']);
}
}

// Проверка сообщения
if (empty($message_content)) {
$errors[] = 'Пожалуйста, введите текст сообщения.';
} else {
$allowed_tags = '<b><i><u><strong><em><a><br><span><p><ul><ol><li>';
$message_content = strip_tags($message_content, $allowed_tags);
// Защита от JS в ссылках
$message_content = preg_replace('/<a([^>]*)href=["\'](javascript|data):/i', '<a$1href="blocked:' , $message_content);
}

// Проверка URL
if (!empty($website) && !filter_var($website, FILTER_VALIDATE_URL)) {
$errors[] = 'Указан некорректный URL сайта.';
}

if (empty($errors)) {
if ($message_id) {
// --- ОБНОВЛЕНИЕ (UPDATE) ---
$can_update = false;
$message_info = null;

// Получаем текущие данные сообщения перед обновлением
$stmt_check = $pdo->prepare("SELECT email, created_at FROM guestbook WHERE id = ? LIMIT 1");
$stmt_check->execute([$message_id]);
$message_info = $stmt_check->fetch(PDO::FETCH_ASSOC);

if ($is_admin) {
$can_update = true;
} elseif ($dudu2_user) {
if ($message_info && $message_info['email'] === $dudu2_user['email']) {
$message_timestamp = strtotime($message_info['created_at']);
if ($message_timestamp >= (time() - $one_month_in_seconds)) {
$can_update = true;
}
}
}

if ($can_update && $message_info) {
// ВАЖНО: Если админ редактирует ЧУЖОЕ сообщение
if ($is_admin && $message_info['email'] !== $dudu2_user['email']) {
// Исключаем name и email из обновления, чтобы не присвоить сообщение админу
// created_at = created_at гарантирует сохранение старой даты
$stmt = $pdo->prepare("UPDATE guestbook SET city = ?, website = ?, message = ?, created_at = created_at WHERE id = ?");
$stmt->execute([$city, $website, $message_content, $message_id]);
} else {
// Если пользователь правит свое, или админ свое - обновляем все поля
$stmt = $pdo->prepare("UPDATE guestbook SET name = ?, email = ?, city = ?, website = ?, message = ?, created_at = created_at WHERE id = ?");
$stmt->execute([$name, $email, $city, $website, $message_content, $message_id]);
}
$_SESSION['main_form_success'] = 'Сообщение успешно обновлено.';
} else {
$_SESSION['main_form_error'] = 'Нет прав или истек срок.';
}
} else {
// --- СОЗДАНИЕ НОВОГО (INSERT) ---
$stmt = $pdo->prepare("INSERT INTO guestbook (name, email, city, website, message, reply_to) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->execute([$name, $email, $city, $website, $message_content, $replyTo]);
$_SESSION['main_form_success'] = 'Сообщение успешно добавлено.';
}
header('Location: index.php');
exit;
} else {
// Обработка ошибок валидации
$error = implode('<br>', $errors);
if ($is_reply_form && $replyTo) {
$_SESSION['reply_error_parent_id'] = $replyTo;
$_SESSION['reply_error_fields'] = [
'name' => $name,
'email' => $email,
'city' => $city,
'website' => $website,
'message' => $message_content,
];
$_SESSION['reply_error_message'] = $error;
} else {
$_SESSION['main_form_error'] = $error;
if ($message_id) {
$_SESSION['main_form_fields'] = [
'name' => $name,
'email' => $email,
'city' => $city,
'website' => $website,
'message' => $message_content,
'message_id' => $message_id
];
}
}
header('Location: index.php');
exit;
}
}

// --- ПОДГОТОВКА ПЕРЕМЕННЫХ ДЛЯ ШАБЛОНА ---
$main_form_success = '';
if (isset($_SESSION['main_form_success'])) {
$main_form_success = $_SESSION['main_form_success'];
unset($_SESSION['main_form_success']);
}

$main_form_error = '';
if (isset($_SESSION['main_form_error'])) {
$main_form_error = $_SESSION['main_form_error'];
unset($_SESSION['main_form_error']);
}

$main_form_fields = [];
if (isset($_SESSION['main_form_fields'])) {
$main_form_fields = $_SESSION['main_form_fields'];
unset($_SESSION['main_form_fields']);
$name = $main_form_fields['name'] ?? $name;
$email = $main_form_fields['email'] ?? $email;
$city = $main_form_fields['city'] ?? $city;
$website = $main_form_fields['website'] ?? $website;
$message_content = $main_form_fields['message'] ?? $message_content;
$editing_message_id = $main_form_fields['message_id'] ?? $editing_message_id;
}

$reply_error_parent_id = null;
$reply_error_fields = [];
$reply_error_message = '';
if (isset($_SESSION['reply_error_parent_id'])) {
$reply_error_parent_id = $_SESSION['reply_error_parent_id'];
$reply_error_fields = $_SESSION['reply_error_fields'] ?? [];
$reply_error_message = $_SESSION['reply_error_message'] ?? '';
unset($_SESSION['reply_error_parent_id']);
unset($_SESSION['reply_error_fields']);
unset($_SESSION['reply_error_message']);
}

// --- ПАГИНАЦИЯ ---
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

$limit = 9;
$offset = ($page - 1) * $limit;

$totalMessagesStmt = $pdo->query("SELECT COUNT(*) FROM guestbook WHERE reply_to IS NULL");
$totalMessages = $totalMessagesStmt->fetchColumn();
$totalPages = ceil($totalMessages / $limit);

if ($offset >= $totalMessages && $totalMessages > 0) {
$page = $totalPages;
$offset = ($page - 1) * $limit;
} elseif ($totalMessages == 0) {
$page = 1;
$offset = 0;
}

// Выбираем сообщения верхнего уровня. Сортировка по ID, чтобы ID был "по порядку"
$stmt = $pdo->prepare("SELECT * FROM guestbook WHERE reply_to IS NULL ORDER BY id DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$mainMessages = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head>
<meta http-equiv='content-type' content='text/html; charset=windows-1251'>
<meta http-equiv='content-language' content='ru'>
<title>Гостевая книга</title>
<link rel="icon" type="image/x-icon" href="/img/favicon.ico">
<link href="f/style.css" rel="stylesheet" type="text/css">
<style>
/* Стиль для выделения активной страницы в пагинации */
.pagination a.active-page {
    color: #ff8c00; 
    font-weight: bold;
}
</style>
<script type='text/javascript' src='f/jscript.js'></script>
<script>
function toggleReplyForm(id) {
var formDiv = document.getElementById('reply-form-container-' + id);
if (formDiv.style.display === 'none') {
formDiv.style.display = 'block';
} else {
formDiv.style.display = 'none';
}
}
function handleWebsiteClick(link) {
var url = link.getAttribute('data-website');
if (url) {
window.open(url, '_blank');
}
return false; // Отменяем стандартное действие перехода по '#'
}
</script>
</head>
<body>
<center>
<table width="350" align="center" border="1" class="main">
<tbody class="info">
<tr>
<td>
<center><b>Гостевая книга</b></center>
<hr class="hr_2">
<table width='100%' cellspacing='0' cellpadding='0' class='board'>
<tr><td class='pages'>
<div class="pagination">
<?php if ($totalPages > 1): ?>
<b>Страница <?= $page ?> из <?= $totalPages ?>:</b>
<?php for ($i = 1; $i <= $totalPages; $i++): ?>
<a href="?page=<?= $i ?>" class="<?= ($i == $page) ? 'active-page' : '' ?>">[<?= $i ?>]</a>
<?php endfor; ?>
<?php endif; ?>
</div>
</tr></td>
</table><br>

<div class="messages">
<?php if (!empty($mainMessages)): ?>
<?php foreach ($mainMessages as $message): ?>
<table width='100%' cellspacing='0' cellpadding='0' class='board'>
<tr>
<td class='msgtopuname'><strong><?= htmlspecialchars($message['name']) ?></strong></td>
<td class='msgtopdate'><span><?= date('H:i, d.m.Y', strtotime($message['created_at'])) ?></span></td>
<td class='msgtopip'>#<?= $message['id'] ?></td>
</tr>
<tr>
<td class='msgudata'>
<?php if (!empty($message['website'])): ?>
&nbsp;<img src="img/url.gif"> <a href="#" onclick="return handleWebsiteClick(this);" data-website="<?= htmlspecialchars($message['website']) ?>" rel="nofollow noopener" target="_blank">Ссылка на сайт</a><br>
<?php endif; ?>
<?php if (!empty($message['city'])): ?>
&nbsp;<img src="img/city.gif"> <?= htmlspecialchars($message['city']) ?>
<?php endif; ?>
</td>
<td colspan='2' class='msgtext'><?= $message['message'] ?>
<?php
// Загрузка ответов на это сообщение
$stmtReplies = $pdo->prepare("SELECT * FROM guestbook WHERE reply_to = ? ORDER BY created_at ASC");
$stmtReplies->execute([$message['id']]);
$replies = $stmtReplies->fetchAll(PDO::FETCH_ASSOC);
?>
<?php if (!empty($replies)): ?>
<div class="replies">
<?php foreach ($replies as $reply): ?>
<div class="answer">
<span class='miniword'>Ответ:</span><br>
<?= $reply['message'] ?>
<div style="text-align: right; margin-top: 2px; font-size: 10px;">
<?php
// Проверка прав на редактирование ответа
$can_edit_reply = false;
if ($is_admin) {
$can_edit_reply = true;
} elseif ($dudu2_user && $reply['email'] === $dudu2_user['email']) {
if (strtotime($reply['created_at']) >= (time() - $one_month_in_seconds)) {
$can_edit_reply = true;
}
}
if ($can_edit_reply):
?>
<a href="?action=edit&id=<?= $reply['id'] ?>">Ред.</a>
<a href="?action=delete&id=<?= $reply['id'] ?>" onclick="return confirm('Удалить этот ответ?');">Удал.</a>
<?php endif; ?>
</div>
</div>
<?php endforeach; ?>
</div>
<?php endif; ?>
</td>
</tr>
</table>

<div style="text-align: right; margin-top: 5px;">
<?php
$show_user_edit_delete = false;
if ($dudu2_user) {
$message_timestamp = strtotime($message['created_at']);
if ($message['email'] === $dudu2_user['email'] && $message_timestamp >= (time() - $one_month_in_seconds)) {
$show_user_edit_delete = true;
}
}
?>

<?php if ($is_admin || $show_user_edit_delete): ?>
<a href="?action=edit&id=<?= $message['id'] ?>" class="btn edit">Редактировать</a>
<a href="?action=delete&id=<?= $message['id'] ?>" class="btn delete" onclick="return confirm('Вы уверены, что хотите удалить это сообщение и все ответы на него?');">Удалить</a>
<?php endif; ?>

<?php
// Кнопка "Ответить" видна только админу
if ($is_admin):
?>
<button type="button" onclick="toggleReplyForm(<?= $message['id'] ?>)">Ответить</button>
<?php endif; ?>
</div>

<div id="reply-form-container-<?= $message['id'] ?>" class="reply-form-container" style="display: <?php echo ($reply_error_parent_id == $message['id']) ? 'block' : 'none'; ?>; margin-top: 10px; border: 1px dashed #ccc; padding: 10px;">
<?php if ($reply_error_parent_id == $message['id']): ?>
<div class="alert alert-error"><?= $reply_error_message ?></div>
<?php endif; ?>

<form method="POST" id="reply-form-<?= $message['id'] ?>">
<input type="hidden" name="reply_to" value="<?= $message['id'] ?>">
<input type="hidden" name="is_reply_form" value="1">

<?php
// Поля формы ответа (только для админа)
if ($is_admin):
?>
<table class='board'>
<tr>
<td>Ваше имя:</td>
<td><input type="text" id="reply-name-<?= $message['id'] ?>" name="name"
value="<?= htmlspecialchars($name) ?>"
<?= $dudu2_user ? 'readonly' : 'required' ?>></td>
</tr>
<tr>
<td>E-mail:</td>
<td><input type="email" id="reply-email-<?= $message['id'] ?>" name="email"
value="<?= htmlspecialchars($email) ?>"
<?= $dudu2_user ? 'readonly' : '' ?>></td>
</tr>
<tr>
<td>Ваш сайт:</td>
<td><input type="url" id="reply-website-<?= $message['id'] ?>" name="website"
value="<?= htmlspecialchars($reply_error_parent_id == $message['id'] ? ($reply_error_fields['website'] ?? '') : '') ?>"></td>
</tr>
<tr>
<td>Город:</td>
<td><input type="text" id="reply-city-<?= $message['id'] ?>" name="city"
value="<?= htmlspecialchars($reply_error_parent_id == $message['id'] ? ($reply_error_fields['city'] ?? '') : '') ?>"></td>
</tr>
<tr>
<td>Сообщение:</td>
<td>
<textarea id="reply-message-<?= $message['id'] ?>" name="message" rows="4" required><?= htmlspecialchars($reply_error_parent_id == $message['id'] ? ($reply_error_fields['message'] ?? '') : '') ?></textarea>
</td>
</tr>
<tr>
<td colspan="2" style="text-align: center;">
<button type="submit">Отправить ответ</button>
<button type="button" onclick="toggleReplyForm(<?= $message['id'] ?>)">Отмена</button>
</td>
</tr>
</table>
<?php endif; ?>
</form>
</div>
<br>
<?php endforeach; ?>
<?php else: ?>
<p>Пока нет сообщений.</p>
<?php endif; ?>
</div>

<table width='100%' cellspacing='0' cellpadding='0' class='board'><tr><td class='pages'>
<div class="pagination">
<?php if ($totalPages > 1): ?>
<b>Страница <?= $page ?> из <?= $totalPages ?>:</b>
<?php for ($i = 1; $i <= $totalPages; $i++): ?>
<a href="?page=<?= $i ?>" class="<?= ($i == $page) ? 'active-page' : '' ?>">[<?= $i ?>]</a>
<?php endfor; ?>
<?php endif; ?>
</div>
</tr></td></table><br>

<?php if (!empty($main_form_error)): ?>
<div class="alert alert-error">
<?= $main_form_error ?>
</div>
<?php endif; ?>

<?php if (!empty($main_form_success)): ?>
<div class="alert alert-success" style="color: green;">
<?= $main_form_success ?>
</div>
<?php endif; ?>

<form method="POST" id="guestbook-form-id">
<table class='board'>
<input type="hidden" name="reply_to" id="reply_to_field" value="<?= htmlspecialchars($replyTo ?? '') ?>">
<?php if ($editing_message_id): ?>
<input type="hidden" name="message_id" value="<?= htmlspecialchars($editing_message_id) ?>">
<?php endif; ?>
<tr>
<td>* Ваше имя:</td>
<td><input type="text" id="name" name="name" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($name) ?>"
<?= $dudu2_user ? 'readonly' : 'required' ?>></td>
<td>Ваш сайт:</td>
<td><input type="url" id="website" name="website" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($website) ?>"></td>
</tr>
<tr>
<td>E-mail:</td>
<td><input type="email" id="email" name="email" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($email) ?>"
<?= $dudu2_user ? 'readonly' : '' ?>></td>
<td>Город:</td>
<td><input type="text" id="city" name="city" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($city) ?>"></td>
</tr>
<tr>
<td>* Введите текст сообщения:</td>
<td colspan="3"><textarea id="message" name="message" style="width: 515px; height: 100px;" required><?= htmlspecialchars($message_content) ?></textarea></td>
</tr>
<?php if (!$dudu2_user): ?>
<tr>
<td>* Код с картинки:</td>
<td colspan="3">
<img src="captcha.php?_t=<?= time() ?>" alt="Капча" class="captcha-img">
<input type="text" name="captcha" style="width: 100px; height: 20px;">
</td>
</tr>
<?php endif; ?>
<tr>
<td colspan="4" style="text-align: center;">
<button class='button' type="submit"><?= $editing_message_id ? 'Сохранить изменения' : 'Добавить' ?></button>
<?php if ($editing_message_id): ?>
<a href="index.php" style="margin-left: 10px;">Отмена редактирования</a>
<?php endif; ?>
</td>
</tr>
</table>
</form>

<div class="dudu2-auth-block">
<?php if ($dudu2_user): ?>
<a href="<?= htmlspecialchars(SITE_URL . '?action=dudu2_logout'); ?>">Выйти</a>
<?php else: ?>
<h4>Войти через ДуДу2.ID</h4>
<a href="<?= htmlspecialchars(AUTH_LOGIN_URL . '&redirect_uri=' . urlencode(SITE_URL)); ?>">Войти</a>
<?php endif; ?>
</div>

</td>
</tr>
</tbody>
</table>
</center>
</body>
</html>