# Михлин Б.
'''
14.508 *(А. Богданов) Арифметическое выражение SIRIUS(p) + LYCEUM(q)
содержит числа, записанные в системах счисления с основаниями р и q.
Заглавные латинские буквы от A до Z обозначают цифры со значениями от 10 до 35 соответственно.
Найдите минимальную сумму p+q, при которых значение этого выражения кратно 2025.
Запишите в ответе частное от деления значения этого выражения на 2025 в десятичной системе счисления.
Примечание: значения p и q могут быть больше, чем 36. 
'''
r = []
for p in range(31, 150):                # старшая цифра в числе SIRIUS 'U'=30 -> 'p' от 31
    a = 28 * p**5 + 18 * p**4 + 27 * p**3 + 18 * p**2 + 30 * p + 28     # развернутая запись числа SIRIUS(p)
    for q in range(35, 150):            # старшая цифра в числе LYCEUM 'Y'=34 -> 'q' от 35
        b = 21 * q**5 + 34 * q**4 + 12 * q**3 + 14 * q**2 + 30 * q + 22 # развернутая запись числа LYCEUM(q)
        v = a + b
        if v % 2025 == 0:
            r.append((p + q, v // 2025))
print(min(r)) # (75, 2009655) Ответ: 2009655
