<?php
session_start();

// --- НАСТРОЙКИ АДМИНА ---
$ADMIN_LOGIN = 'admin'; // Установите свой логин
$ADMIN_PASS_HASH = '$2y$10$pdhjFEIL6jEl7PpkS4V4ZunWLCKDmt3W.gdq9OaqscmnLbXRV6S2S'; // Хеш для пароля 'admin'
$ADMIN_NAME = 'Администратор';
$ADMIN_EMAIL = ''; 
// ---
// --- НАСТРОЙКИ ФАЙЛОВОЙ СИСТЕМЫ ---
$DATA_FILE = 'guestbook_data.json';
// ---

// --- ФУНКЦИИ ДЛЯ РАБОТЫ С ФАЙЛОМ ---

/**
* Читает данные из JSON-файла. 
*/
function readData($file) {
if (!file_exists($file) || filesize($file) === 0) {
// Если файл не существует, создаем его с начальной структурой
$initial_data = ['messages' => [], 'last_id' => 0];
file_put_contents($file, json_encode($initial_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);
return $initial_data;
}
// Используем flock для безопасного чтения
$handle = fopen($file, 'r');
if ($handle === false) {
throw new Exception("Не удалось открыть файл данных для чтения.");
}
flock($handle, LOCK_SH);
$content = stream_get_contents($handle);
flock($handle, LOCK_UN);
fclose($handle);

$data = json_decode($content, true);
return $data ?: ['messages' => [], 'last_id' => 0];
}

/**
* Записывает данные обратно в JSON-файл.
*/
function writeData($file, $data) {
$json_content = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
// Используем flock для безопасной записи
$result = file_put_contents($file, $json_content, LOCK_EX);
if ($result === false) {
throw new Exception("Не удалось записать данные в файл.");
}
}

// --- ИНИЦИАЛИЗАЦИЯ (Загрузка данных) ---
try {
$guestbook_data = readData($DATA_FILE);
} catch (Exception $e) {
die('Критическая ошибка при загрузке данных: ' . $e->getMessage());
}

// Проверка: является ли пользователь админом через простую сессию
$is_admin = (isset($_SESSION['is_admin_simple']) && $_SESSION['is_admin_simple'] === true);

// --- ЛОГИКА ВХОДА ДЛЯ admin.php ---
if (!$is_admin && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_login'])) {
$input_login = $_POST['admin_login'] ?? '';
$input_pass = $_POST['admin_pass'] ?? '';

if ($input_login === $ADMIN_LOGIN && password_verify($input_pass, $ADMIN_PASS_HASH)) {
$_SESSION['is_admin_simple'] = true;
header('Location: admin.php'); // Ссылка на себя
exit;
} else {
$_SESSION['admin_login_error'] = 'Неверный логин или пароль.';
}
}

// --- ЗАЩИТА СТРАНИЦЫ ADMIN.PHP ---
if (!$is_admin) {
// Форма входа
?>
<!DOCTYPE html>
<html>
<head>
<title>Вход для администратора</title>
<link href="scripts/style.css" rel="stylesheet" type="text/css">
</head>
<body>
<center>
<table width="350" align="center" border="1" class="main">
<tbody class="info">
<tr class="info"><td align="center">
<b>Гостевая книга АДМИНЦЕНТР</b>
</td></tr>
<tr><td>

    <form method="POST">
		<table width='100%' cellspacing='5' cellpadding='0' class='board'>
		<tr><td colspan='2' align='center'><font color='red'><strong>ВХОД В АДМИНЦЕНТР</strong></font></td></tr>
        <?php if (isset($_SESSION['admin_login_error'])): ?>
            <p style="color: red;"><?= $_SESSION['admin_login_error']; unset($_SESSION['admin_login_error']); ?></p>
        <?php endif; ?>
		<tr><td width='50%' align='right'>Логин: &nbsp;</td><td  width='50%' align='left'>
			<input type="text" name="admin_login" style="width: 200px; height: 15px;"></td></tr>	
		<tr><td align='right'>Пароль: &nbsp;</td><td align='left'>
			<input type="password" name="admin_pass" style="width: 200px; height: 15px;"></td></tr>
		<tr><td colspan='2' align='center'><input type='submit' value='Войти' class='button' /></td></tr>
		</table>
	</form>
<br />
<table width='100%' cellspacing='0' cellpadding='0' class='board'>
<tr><td><center><a href="index.php">Перейти на главную</a></center></td></tr>
</table>
</td></tr>	
</center>
</body>
</html>
    <?php
exit;
}
// --- КОНЕЦ ЗАЩИТЫ ---

// Инициализация переменных формы
$name = $ADMIN_NAME;
$email = $ADMIN_EMAIL;
$city = '';
$website = '';
$message_content = '';
$replyTo = null;

$editing_message_id = null;
$editing_message_data = [];

// --- ВСПОМОГАТЕЛЬНЫЕ ФУНКЦИИ ---

/**
* Находит сообщение или ответ по ID, возвращая ссылки на них и их индексы.
* Использует строгое сравнение (===) после приведения ID к строке.
*/
function &findMessageById(&$data, $id) {
    $null = null;
    // Ensure the ID we are searching for is treated as a string, as it comes from $_GET or $_POST.
    $id_to_find = (string)$id; 

    foreach ($data['messages'] as $mainIndex => &$mainMsg) {
        // 1. Поиск основного сообщения: строго сравниваем две строки: '21' === '21'
        if ((string)$mainMsg['id'] === $id_to_find) { 
            return ['mainMsg' => &$mainMsg, 'mainIndex' => $mainIndex, 'replyMsg' => $null, 'replyIndex' => $null];
        }
        
        // 2. Поиск ответа: строго сравниваем две строки: '21.1' === '21.1'
        foreach ($mainMsg['replies'] as $replyIndex => &$replyMsg) {
            if ($replyMsg['id'] === $id_to_find) {
                return ['mainMsg' => &$mainMsg, 'mainIndex' => $mainIndex, 'replyMsg' => &$replyMsg, 'replyIndex' => $replyIndex];
            }
        }
        unset($replyMsg);
    }
    unset($mainMsg);
    return ['mainMsg' => $null, 'mainIndex' => $null, 'replyMsg' => $null, 'replyIndex' => $null];
}

/**
 * Пересчитывает все ID основных сообщений и их ответов после удаления.
 * Обновляет $data['messages'] и $data['last_id'].
 */
function reindexMessages(&$data) {
    $new_messages = [];
    $new_id = 0;

    foreach ($data['messages'] as $oldMsg) {
        $new_id++;
        
        $newMsg = $oldMsg;
        $newMsg['id'] = $new_id;
        
        // Обновляем ID ответов
        $newMsg['replies'] = [];
        if (!empty($oldMsg['replies'])) {
            $reply_index = 0;
            foreach ($oldMsg['replies'] as $oldReply) {
                $reply_index++;
                $newReply = $oldReply;
                // Новый строковый ID: "новый_родительский_ID.индекс_ответа"
                $newReply['id'] = $new_id . '.' . $reply_index;
                $newMsg['replies'][] = $newReply;
            }
        }
        
        $new_messages[] = $newMsg;
    }

    $data['messages'] = $new_messages;
    $data['last_id'] = $new_id;
}


// --- ЛОГИКА УДАЛЕНИЯ (ADMIN) ---
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
$message_id_to_delete = $_GET['id']; // ID оставляем строкой
try {
$found = findMessageById($guestbook_data, $message_id_to_delete);
$mainMsg = &$found['mainMsg'];
$mainIndex = $found['mainIndex'];
$replyMsg = $found['replyMsg'];
$replyIndex = $found['replyIndex'];

if ($mainMsg) {
    if ($replyMsg) {
        // Удаление ответа
        array_splice($mainMsg['replies'], $replyIndex, 1);
        $_SESSION['main_form_success'] = 'Ответ (' . htmlspecialchars($message_id_to_delete) . ') удален.';

        // Переиндексация ответов внутри родительского сообщения (21.2 -> 21.1)
        $parent_id = $mainMsg['id']; // ID родительского сообщения (число)
        $new_replies = [];
        $reply_index = 0;
        foreach ($mainMsg['replies'] as $reply) {
            $reply_index++;
            $reply['id'] = $parent_id . '.' . $reply_index;
            $new_replies[] = $reply;
        }
        $mainMsg['replies'] = $new_replies;

    } else {
        // Удаление основного сообщения и всех его ответов
        array_splice($guestbook_data['messages'], $mainIndex, 1);
        $_SESSION['main_form_success'] = 'Сообщение (' . htmlspecialchars($message_id_to_delete) . ') и ответы удалены. Произведена переиндексация.';
        
        // ВЫЗЫВАЕМ ПЕРЕИНДЕКСАЦИЮ ВСЕХ СООБЩЕНИЙ
        reindexMessages($guestbook_data); 
    }

    writeData($DATA_FILE, $guestbook_data);
} else {
    $_SESSION['main_form_error'] = 'Сообщение/ответ не найдено.';
}
} catch (Exception $e) {
$_SESSION['main_form_error'] = 'Ошибка при удалении: ' . $e->getMessage();
}
header('Location: admin.php'); // Ссылка на себя
exit;
}

// --- ЛОГИКА ПОДГОТОВКИ К РЕДАКТИРОВАНИЮ (GET) (ADMIN) ---
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['id'])) {
$editing_message_id = $_GET['id']; // ID оставляем строкой
$found = findMessageById($guestbook_data, $editing_message_id);
$mainMsg = $found['mainMsg'];
$replyMsg = $found['replyMsg'];
$editing_message_data = $replyMsg ?: $mainMsg; // Редактируемое сообщение (либо ответ, либо основное)

if ($editing_message_data) {
$name = $editing_message_data['name'];
$email = $editing_message_data['email'];
$city = $editing_message_data['city'];
$website = $editing_message_data['website'];
$message_content = $editing_message_data['message'];
$replyTo = $replyMsg ? null : $editing_message_data['reply_to']; // replyTo только для новых основных сообщений
$_SESSION['main_form_success'] = 'Редактирование сообщения #' . htmlspecialchars($editing_message_id);
} else {
$_SESSION['main_form_error'] = 'Сообщение не найдено.';
header('Location: admin.php'); // Ссылка на себя
exit;
}
}

// --- ОБРАБОТКА ОТПРАВКИ ФОРМЫ (POST) (ADMIN) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
$is_reply_form = isset($_POST['is_reply_form']) && $_POST['is_reply_form'] == '1';

$input_name = trim($_POST['name'] ?? $name);
$input_email = trim($_POST['email'] ?? $email);

$city = trim($_POST['city'] ?? '');
$website = trim($_POST['website'] ?? '');
$message_content = trim($_POST['message'] ?? '');

$replyTo = !empty($_POST['reply_to']) ? (int)$_POST['reply_to'] : null;
$message_id = $_POST['message_id'] ?? null;

$errors = [];

if (empty($message_content)) {
$errors[] = 'Пожалуйста, введите текст сообщения.';
} else {
// Очистка сообщения
$allowed_tags = '<b><i><u><strong><em><a><br><span><p><ul><ol><li>';
$message_content = strip_tags($message_content, $allowed_tags);
$message_content = preg_replace('/<a([^>]*)href=["\'](javascript|data):/i', '<a$1href="blocked:' , $message_content);
}

if (!empty($website) && !filter_var($website, FILTER_VALIDATE_URL)) {
$errors[] = 'Указан некорректный URL сайта.';
}

if (empty($errors)) {
try {
if ($message_id) {
// --- ОБНОВЛЕНИЕ (UPDATE) (ADMIN) ---
$found = findMessageById($guestbook_data, $message_id);
$mainMsg = &$found['mainMsg'];
$replyMsg = &$found['replyMsg'];

$targetMsg = null;
if ($replyMsg !== null) {
    // Если найден ответ, $targetMsg ссылается на него.
    $targetMsg = &$replyMsg;
} else if ($mainMsg !== null) {
    // Если найдено основное сообщение, $targetMsg ссылается на него.
    $targetMsg = &$mainMsg;
}

if ($targetMsg) {
// Администратор всегда может редактировать имя/email
$targetMsg['name'] = $input_name;
$targetMsg['email'] = $input_email;

$targetMsg['city'] = $city;
$targetMsg['website'] = $website;
$targetMsg['message'] = $message_content;

writeData($DATA_FILE, $guestbook_data);
$_SESSION['main_form_success'] = 'Сообщение #' . htmlspecialchars($message_id) . ' успешно обновлено.';
} else {
$_SESSION['main_form_error'] = 'Сообщение не найдено.';
}
} else {
// --- СОЗДАНИЕ НОВОГО (INSERT) (ADMIN) ---
if ($replyTo) {
// Это ответ (ID будет 'родительский.1', 'родительский.2' и т.д.)
$found = findMessageById($guestbook_data, $replyTo);
$mainMsg = &$found['mainMsg'];

if (!$mainMsg) {
throw new Exception("Не найден родительский комментарий для ответа.");
}

$next_reply_index = count($mainMsg['replies']) + 1;
$new_id = $replyTo . '.' . $next_reply_index; // Новый строковый ID

$new_message = [
'id' => $new_id,
'name' => $ADMIN_NAME,
'email' => $ADMIN_EMAIL,
'city' => $city,
'website' => $website,
'message' => $message_content,
'created_at' => date('Y-m-d H:i:s'),
];
$mainMsg['replies'][] = $new_message;
$_SESSION['main_form_success'] = 'Ответ ' . $new_id . ' успешно добавлен.';

} else {
// Это новое основное сообщение (ID будет числом)
$new_id = $guestbook_data['last_id'] + 1;

$new_message = [
'id' => $new_id,
'reply_to' => null,
'name' => $ADMIN_NAME,
'email' => $ADMIN_EMAIL,
'city' => $city,
'website' => $website,
'message' => $message_content,
'created_at' => date('Y-m-d H:i:s'),
'replies' => [],
];

// Добавляем новое сообщение в массив
$guestbook_data['messages'][] = $new_message;
$guestbook_data['last_id'] = $new_id;
$_SESSION['main_form_success'] = 'Сообщение успешно добавлено.';
}

writeData($DATA_FILE, $guestbook_data);
}

} catch (Exception $e) {
$errors[] = 'Ошибка при сохранении данных: ' . $e->getMessage();
}

if (empty($errors)) {
header('Location: admin.php'); // Ссылка на себя
exit;
}
} 

$error = implode('<br>', $errors);
if ($is_reply_form && $replyTo) {
$_SESSION['reply_error_parent_id'] = $replyTo;
$_SESSION['reply_error_fields'] = [
'name' => $input_name,
'email' => $input_email,
'city' => $city,
'website' => $website,
'message' => $message_content,
];
$_SESSION['reply_error_message'] = $error;
} else {
$_SESSION['main_form_error'] = $error;
if ($message_id) {
$_SESSION['main_form_fields'] = [
'name' => $input_name,
'email' => $input_email,
'city' => $city,
'website' => $website,
'message' => $message_content,
'message_id' => $message_id
];
}
}
header('Location: admin.php'); // Ссылка на себя
exit;
}

// --- ПОДГОТОВКА ПЕРЕМЕННЫХ ДЛЯ ШАБЛОНА (ADMIN) и ПАГИНАЦИЯ ---
$main_form_success = isset($_SESSION['main_form_success']) ? $_SESSION['main_form_success'] : '';
unset($_SESSION['main_form_success']);

$main_form_error = isset($_SESSION['main_form_error']) ? $_SESSION['main_form_error'] : '';
unset($_SESSION['main_form_error']);

if (isset($_SESSION['main_form_fields'])) {
$main_form_fields = $_SESSION['main_form_fields'];
unset($_SESSION['main_form_fields']);
$name = $main_form_fields['name'] ?? $name;
$email = $main_form_fields['email'] ?? $email;
$city = $main_form_fields['city'] ?? $city;
$website = $main_form_fields['website'] ?? $website;
$message_content = $main_form_fields['message'] ?? $message_content;
$editing_message_id = $main_form_fields['message_id'] ?? $editing_message_id;
}

$reply_error_parent_id = isset($_SESSION['reply_error_parent_id']) ? $_SESSION['reply_error_parent_id'] : null;
$reply_error_fields = isset($_SESSION['reply_error_fields']) ? $_SESSION['reply_error_fields'] : [];
$reply_error_message = isset($_SESSION['reply_error_message']) ? $_SESSION['reply_error_message'] : '';
unset($_SESSION['reply_error_parent_id'], $_SESSION['reply_error_fields'], $_SESSION['reply_error_message']);


// --- ПАГИНАЦИЯ ---
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

$limit = 9;
$allMessages = $guestbook_data['messages'];

// СОРТИРОВКА: Новые сообщения сверху (DESC по дате)
usort($allMessages, function($a, $b) {
return strtotime($b['created_at']) - strtotime($a['created_at']);
});

$totalMessages = count($allMessages);
$totalPages = ceil($totalMessages / $limit);

if ($page > $totalPages && $totalPages > 0) {
$page = $totalPages;
} elseif ($totalMessages == 0) {
$page = 1;
}

$offset = ($page - 1) * $limit;
$mainMessages = array_slice($allMessages, $offset, $limit);
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv='content-type' content='text/html; charset=utf-8'>
<meta http-equiv='content-language' content='ru'>
<title>Гостевая книга (ADMIN)</title>
<link rel="icon" type="image/x-icon" href="/img/favicon.ico">
<link href="scripts/style.css" rel="stylesheet" type="text/css">
<style>
.pagination a.active-page {
color: #ff8c00; 
font-weight: bold;
}
</style>
<script type='text/javascript' src='scripts/jscript.js'></script>
<script type='text/javascript' src='scripts/js.js'></script>
<script>
	function toggleReplyForm(id) {
	var formDiv = document.getElementById('reply-form-container-' + id);
	if (formDiv.style.display === 'none') {
	formDiv.style.display = 'block';
	} else {
	formDiv.style.display = 'none';
	}
	}

	function handleWebsiteClick(link) {
	var url = link.getAttribute('data-website');
	if (url) {
	window.open(url, '_blank');
	}
	return false;
	}
</script>
</head>
<body>
<center>
<table width="350" align="center" border="1" class="main">
<tbody class="info">
<tr><td>
<center><b>Гостевая книга (ADMINISTRATOR)</b></center>
</td></tr>
<tr><td>
<table width='100%' cellspacing='0' cellpadding='0' class='board'>
<tr><td class='pages'>
<div class="pagination">
<?php if ($totalPages > 1): ?>
<b>Страница <?= $page ?> из <?= $totalPages ?>:</b>
<?php for ($i = 1; $i <= $totalPages; $i++): ?>
<a href="?page=<?= $i ?>" class="<?= ($i == $page) ? 'active-page' : '' ?>">[<?= $i ?>]</a>
<?php endfor; ?>
<?php endif; ?>
</div>
</tr></td>
</table><br>

<div class="messages">
<?php if (!empty($mainMessages)): ?>
<?php foreach ($mainMessages as $message): ?>
<table width='100%' cellspacing='0' cellpadding='0' class='board'>
<tr>
	<td class='msgtopuname'><strong><?= htmlspecialchars($message['name']) ?></strong></td>
	<td class='msgtopdate'><span><?= date('H:i, d.m.Y', strtotime($message['created_at'])) ?></span></td>
	<td class='msgtopip'>#<?= $message['id'] ?></td>
</tr>
<tr>
<td class='msgudata'><?php if (!empty($message['website'])): ?>&nbsp;<img src="img/url.gif"> <a href="#tosite" onclick="return handleWebsiteClick(this);" data-website="<?= htmlspecialchars($message['website']) ?>" rel="nofollow noopener" target="_blank">Ссылка на сайт</a><br><?php endif; ?><?php if (!empty($message['city'])): ?>&nbsp;<img src="img/city.gif"> <?= htmlspecialchars($message['city']) ?><?php endif; ?>
</td>
<td colspan='2' class='msgtext'>
<?= nl2br($message['message']) ?> 
<?php if (!empty($message['replies'])): ?>
<div class="replies">
<?php foreach ($message['replies'] as $reply): ?>
<div class="answer">
<span class='miniword'>Ответ #<?= htmlspecialchars($reply['id']) ?>:</span><br>
<?= nl2br($reply['message']) ?> 
<div style="text-align: right; margin-top: 2px; font-size: 10px;">
<a href="?action=edit&id=<?= htmlspecialchars($reply['id']) ?>" class='button'>Ред.</a>
<a href="?action=delete&id=<?= htmlspecialchars($reply['id']) ?>" onclick="return confirm('Удалить этот ответ?');" class='button'>Удал.</a>
</div>
</div>
<?php endforeach; ?>
</div>
<?php endif; ?>
</td>
</tr>
</table>

<div style="text-align: right; margin-top: 5px;">
<a href="?action=edit&id=<?= $message['id'] ?>" class='button'>Редактировать</a>
<a href="?action=delete&id=<?= $message['id'] ?>" class='button' onclick="return confirm('Вы уверены, что хотите удалить это сообщение и все ответы на него?');">Удалить</a>

<button type="button" class='button' onclick="toggleReplyForm(<?= $message['id'] ?>)">Ответить</button>
</div>

<div id="reply-form-container-<?= $message['id'] ?>" class="reply-form-container" style="display: <?php echo ($reply_error_parent_id == $message['id']) ? 'block' : 'none'; ?>; margin-top: 10px; border: 1px dashed #ccc; padding: 10px;">
<?php if ($reply_error_parent_id == $message['id']): ?>
<div class="alert alert-error"><?= $reply_error_message ?></div>
<?php endif; ?>

<form method="POST" id="reply-form-<?= $message['id'] ?>">
<input type="hidden" name="reply_to" value="<?= $message['id'] ?>">
<input type="hidden" name="is_reply_form" value="1">

<table class='board'>
<tr><td><center>Сообщение:</center></td></tr>
<tr><td><textarea id="reply-message-<?= $message['id'] ?>" name="message" rows="4"><?= htmlspecialchars($reply_error_parent_id == $message['id'] ? ($reply_error_fields['message'] ?? '') : '') ?></textarea></td></tr>

<tr>
<td colspan="2" style="text-align: center;">
	<input type='submit' value='Отправить ответ' class='button' />
	<input type="button" onclick="toggleReplyForm(<?= $message['id'] ?>)" value='Отмена' class='button' />
</td>
</tr>
</table>
</form>
</div>
<br>
<?php endforeach; ?>
<?php else: ?>
<p>Пока нет сообщений.</p>
<?php endif; ?>
</div>

<table width='100%' cellspacing='0' cellpadding='0' class='board'><tr><td class='pages'>
<div class="pagination">
<?php if ($totalPages > 1): ?>
<b>Страница <?= $page ?> из <?= $totalPages ?>:</b>
<?php for ($i = 1; $i <= $totalPages; $i++): ?>
<a href="?page=<?= $i ?>" class="<?= ($i == $page) ? 'active-page' : '' ?>">[<?= $i ?>]</a>
<?php endfor; ?>
<?php endif; ?>
</div>
</tr></td></table><br>

<table width="100%" class="board">
<tr><td>
	<?php if (!empty($main_form_error)): ?><div><?= $main_form_error ?></div><?php endif; ?>
	<?php if (!empty($main_form_success)): ?><div><?= $main_form_success ?></div><?php endif; ?>
</td></tr>
</table>

<form method="POST" id="guestbook-form-id">
<table class='board'>
<input type="hidden" name="reply_to" id="reply_to_field" value="">
<?php if ($editing_message_id): ?>
<input type="hidden" name="message_id" value="<?= htmlspecialchars($editing_message_id) ?>">
<?php endif; ?>

<tr>
<td>* Ваше имя:</td><td><input type="text" id="name" name="name" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($name) ?>" required></td>
<td>Ваш сайт:</td><td><input type="url" id="website" name="website" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($website) ?>"></td>
</tr>
<tr>
	
<td>E-mail:</td><td><input type="email" id="email" name="email" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($email) ?>"></td>
<td>Город:</td><td><input type="text" id="city" name="city" style="width: 200px; height: 20px;"
value="<?= htmlspecialchars($city) ?>"></td>
</tr>

<tr><td>* Введите текст сообщения:</td>
<td colspan="3"><textarea id="message" name="message" style="width: 480px; height: 100px;"><?= htmlspecialchars($message_content) ?></textarea></td>
</tr>

<tr><td colspan="4" style="text-align: center;">
	<input type='submit' value='<?= $editing_message_id ? 'Сохранить изменения' : 'Добавить' ?>' class='button' />
	<?php if ($editing_message_id): ?>
		<a href="admin.php" style="margin-left: 10px;">Отмена редактирования</a>
	<?php endif; ?>
</td></tr>
</table>
</form>


<tr><td>
<a href="admin_logout.php">Выйти из панели администратора</a>
<br>
<a href="index.php">Перейти в Гостевую книгу</a>
</td></tr>


</td></tr>
</tbody></table>
</center>
</body>
</html>