function toggleReplyForm(id) {
var formDiv = document.getElementById('reply-form-container-' + id);
if (formDiv.style.display === 'none') {
formDiv.style.display = 'block';
} else {
formDiv.style.display = 'none';
}
}

function handleWebsiteClick(link) {
var url = link.getAttribute('data-website');
if (url) {
window.open(url, '_blank');
}
return false;
}

// --- Логика постоянного сохранения полей в браузере (localStorage) ---
const fieldsToStore = ['name', 'email', 'website', 'city'];

function saveFormFields() {
    fieldsToStore.forEach(fieldId => {
        const input = document.getElementById(fieldId);
        if (input) {
            // Сохраняем данные в localStorage с префиксом
            localStorage.setItem('guestbook_' + fieldId, input.value);
        }
    });
}

function loadFormFields() {
    fieldsToStore.forEach(fieldId => {
        const input = document.getElementById(fieldId);
        if (input) {
            const storedValue = localStorage.getItem('guestbook_' + fieldId);
            // Загружаем значение из localStorage только, если PHP не заполнил поле 
            // (т.е., если не было ошибки валидации, и value="")
            if (storedValue && input.value === '') { 
                input.value = storedValue;
            }
            // Добавляем слушатель для сохранения при изменении
            input.addEventListener('input', saveFormFields);
        }
    });
}

// Вызываем загрузку при полной загрузке страницы
document.addEventListener('DOMContentLoaded', loadFormFields);

// Также, сохраняем при отправке формы, чтобы обновить последние данные
const form = document.getElementById('guestbook-form-id');
if (form) {
    form.addEventListener('submit', saveFormFields);
}
// ---------------------------------------------------------------------
