# Автор: Е. Джобс

n = 10**9 - 10**8      # всего чисел
n -= 9                 # из одной цифры (1-9)

# Число комбинаций из двух цифр - это
# число битовых цепочек длиной 9 => 2**9,
# среди них 2 комбинации из одной цифры, которые уже учтены
# получаем 2**9 - 2 = 510
# Если не учитывать цифру 0, то разных сочетаний двух разных цифр
# будет 9*8/2

n -= 9*8//2*(2**9 - 2)

# Если одна из цифр - 0, то первая цифра 1..9 и для
# каждой первой цифры есть 2**8-1 комбинаций последних 8 цифр

n -= 9*(2**8 - 1)

print( n )

# Программа полного перебора, считает очень долго,
# но можно дождаться ответа

def valid( n ):
  s = set( str(n) )
  return len(s) >= 3

count = 0
for n in range(10**8, 10**9):
  if valid( n ):
    count += 1

print( count )

