﻿"""
Автор: О. Лысенков

*(О. Лысенков) Известно, что число X=****A**_16=****2***3_8.  На месте "*" может быть
любая из цифр соответствующей системы счисления, причём каждая из звёздочек
является значащей цифрой (число не может начинаться с цифры 0). Найдите
количество чисел X, удовлетворяющих этому условию.

Решение:
X_16   ................1010........
       | * | * | * | * | A | * | * |
X_8     ............010.........011
        |* |* |* |* |2 |* |* |* |3 |

X_2     ............0101010.....011
         f |* |* |* |2 |* |* |* |3 |
f != 0 => f - 3 бита, кроме 000 => 7 вариантов
В остальных 14 битах может быть 0 или 1

Ответ: 7*2^14 = 114688
"""
def f(n,osn):
    alphabet = '0123456789ABCDEF'
    s = ''
    while n != 0:
        s = alphabet[n % osn] + s
        n //= osn
    return s
k = 0
for i in range(2**24,8*2**24):
    s8 = f(i,8)
    s16 = f(i,16)
    if s16[4] == 'A' and s8[-1] == '3' and s8[-5] == '2':
        k += 1
print(k)