<?php
$path = isset($_GET['path']) ? $_GET['path'] : '';
$backPath = isset($_GET['back']) ? $_GET['back'] : '';

// Безопасность: проверяем, что путь начинается с music/
if (strpos($path, 'music/') !== 0 && $path !== '') {
    die('<div class="alert alert-danger">Доступ запрещен</div>');
}

if ($path === '') $path = 'music/';

if (is_dir($path)) {
    $items = scandir($path);
    
    foreach ($items as $item) {
        if ($item != '.' && $item != '..') {
            $fullPath = $path . $item;
            if (is_dir($fullPath)) {
                echo '<a href="#" class="list-group-item list-group-item-action folder-item" data-path="' . 
                     htmlspecialchars($fullPath . '/') . '" data-back="' . htmlspecialchars($path) . '">';
                echo '<i class="fas fa-folder me-2"></i>' . htmlspecialchars($item);
                echo '</a>';
            } else {
                $ext = pathinfo($item, PATHINFO_EXTENSION);
                $allowedExtensions = ['mp3', 'wav', 'ogg'];
                if (in_array(strtolower($ext), $allowedExtensions)) {
                    $songName = pathinfo($item, PATHINFO_FILENAME);
                    echo '<a href="#" class="list-group-item list-group-item-action song-item" data-src="' . 
                         htmlspecialchars($fullPath) . '">';
                    echo '<i class="fas fa-music me-2"></i>' . htmlspecialchars($songName);
                    echo '</a>';
                }
            }
        }
    }
} else {
    echo '<div class="alert alert-warning">Папка не найдена!</div>';
}
?>