<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Музыкальный сайт</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container mt-4">
        <h1 class="text-center mb-4">Музыкальная коллекция ДуДу2</h1>
        
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <div class="input-group mb-3">
                    <input type="text" id="searchInput" class="form-control" placeholder="Поиск песен...">
                    <button class="btn btn-outline-secondary" type="button" id="searchButton">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
                
                <div class="breadcrumb-container">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb-nav" id="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#" data-path="music/">Главная</a>
                            </li>
                        </ol>
                    </nav>
                </div>
                
                <div class="list-group" id="contentList">
                    <?php
                    $musicDir = 'music/';
                    displayContent($musicDir);
                    
                    function displayContent($path, $backPath = '') {
                        if (is_dir($path)) {
                            $items = scandir($path);
                            foreach ($items as $item) {
                                if ($item != '.' && $item != '..') {
                                    $fullPath = $path . $item;
                                    if (is_dir($fullPath)) {
                                        echo '<a href="#" class="list-group-item list-group-item-action folder-item" data-path="' . 
                                             htmlspecialchars($fullPath . '/') . '" data-back="' . htmlspecialchars($path) . '">';
                                        echo '<i class="fas fa-folder me-2"></i>' . htmlspecialchars($item);
                                        echo '</a>';
                                    } else {
                                        $ext = pathinfo($item, PATHINFO_EXTENSION);
                                        $allowedExtensions = ['mp3', 'wav', 'ogg'];
                                        if (in_array(strtolower($ext), $allowedExtensions)) {
                                            $songName = pathinfo($item, PATHINFO_FILENAME);
                                            echo '<a href="#" class="list-group-item list-group-item-action song-item" data-src="' . 
                                                 htmlspecialchars($fullPath) . '">';
                                            echo '<i class="fas fa-music me-2"></i>' . htmlspecialchars($songName);
                                            echo '</a>';
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    
	<div class="player-container fixed-bottom d-none">
	    <div class="container">
	        <div class="player-card">
	            <div class="row align-items-center">
	                <div class="col-12 col-md-4">
	                    <div class="song-info text-truncate">
	                        <h6 id="nowPlaying">Не выбрано</h6>
	                        <div class="progress mt-2">
	                            <div class="progress-bar" id="progressBar" role="progressbar" style="width: 0%"></div>
	                        </div>
	                        <div class="time-info">
	                            <span id="currentTime">0:00</span>
	                            <span class="time-separator">/</span>
	                            <span id="duration">0:00</span>
	                        </div>
	                    </div>
	                </div>
	                <div class="col-12 col-md-4 text-center mt-3 mt-md-0">
	                    <div class="player-controls">
	                        <button class="btn btn-link" id="prevBtn" title="Предыдущий трек">
	                            <i class="fas fa-step-backward"></i>
	                        </button>
	                        <button class="btn btn-link play-btn" id="playBtn" title="Воспроизвести/Пауза">
	                            <i class="fas fa-play"></i>
	                        </button>
	                        <button class="btn btn-link" id="nextBtn" title="Следующий трек">
	                            <i class="fas fa-step-forward"></i>
	                        </button>
	                        <button class="btn btn-link" id="repeatBtn" title="Повтор">
	                            <i class="fas fa-redo"></i>
	                        </button>
	                    </div>
	                </div>
	                <div class="col-12 col-md-4 text-center text-md-end mt-3 mt-md-0">
	                    <div class="volume-control">
	                        <i class="fas fa-volume-up volume-icon"></i>
	                        <input type="range" class="form-range volume-slider" id="volumeSlider" min="0" max="1" step="0.01" value="0.7">
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
	</div>
    
    <audio id="audioPlayer"></audio>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="player.js"></script>
</body>
</html>