"""
Автор: О. Лысенков

(О. Лысенков) Исполнитель Редактор получает на вход строку цифр и преобразовывает
её. Редактор может выполнять две команды, в обеих командах v и w обозначают цепочки цифр.
  А) заменить (v, w)
  Б) нашлось (v)
Дана программа для Редактора:
НАЧАЛО
ПОКА нашлось (11) ИЛИ нашлось (444) ИЛИ нашлось (8888)
  ЕСЛИ нашлось (11)
    ТО заменить (11, 4)
  КОНЕЦ ЕСЛИ
  ЕСЛИ нашлось (444)
    ТО заменить (444, 88)
  КОНЕЦ ЕСЛИ
  ЕСЛИ нашлось (8888)
    ТО заменить (8888, 1)
  КОНЕЦ ЕСЛИ
КОНЕЦ ПОКА
КОНЕЦ
На вход приведённой выше программе поступает строка, начинающаяся с цифры «1»,
а затем содержащая n цифр «8» (3<n≤10000). Определите наибольшее возможное значение
n, при котором сумма числовых значений строки, получившейся в результате выполнения
программы, кратна 8.

Ответ: 10000
"""
ans = 0
for n in range(4,10001):
    s = '1'  + '8' * n
    while '11' in s or '444' in s or '8888' in s:
        if  '11' in s:
            s = s.replace('11','4',1)
        if '444' in s:
            s = s.replace('444','88',1)
        if '8888' in s:
            s = s.replace('8888','1',1)
    if sum(int(i) for i in s) % 8 == 0:
        ans = n
print(ans)