"""
Автор: Г. Гутман
Решение. Исполнитель просматривает строку слева направо и в каждом блоке все
единицы, кроме первой, заменяет нулями. Следовательно, в исходной строке было
10 блоков. Если все блоки одинаковы, то параметр k определяется однозначно: k = 50.
Но так как последний блок может быть неполным, то максимальное значение k будет
больше. Для определения kmax можно рассуждать так: позиция первой единицы последнего
блока равна 9*2*k (при нумерации позиций от нуля). Следовательно, нужно найти
максимальное значение k, удовлетворяющее неравенству 18*k < 1000, откуда
получаем, что k < 55.5555… и  kmax = 55
Ответ:  55
Проверим результат программой
"""
mt=[[('_','R',1)],
    [('_','S',1),('0','R',1),('1','R',2)],
    [('_','S',2),('0','R',1),('0','R',2)]]
alf='_01'; p=0

def cmd(mt,s,p):
    q=0; res=list(s)
    while True:
        out,dr,nxt=mt[q][alf.index(res[p])]
        res[p]=out
        if dr=='R': p+=1
        if dr=='L': p-=1
        if dr=='S': return(''.join(res))
        q=nxt

s='_'+ (10*(55*'1' + 55*'0'))[:1000] + '_'
res=cmd(mt,s,p)
print(s.count('0'),s.count('1'))
print(res.count('0'),res.count('1'))
"""
Результат:
495 505    # число нулей и единиц в исходной строке
990 10     # число нулей и единиц в конечной строке
"""