# Python Web Compiler

A web-based Python code editor and executor with user authentication and notebook management.

## Features

- User registration and authentication
- Create, edit, and manage Python notebooks
- Execute Python code in isolated virtual environments
- Share notebooks publicly or keep them private
- Embed notebooks in other websites
- Syntax highlighting with CodeMirror
- Responsive design with Bootstrap 5

## Running with Docker Compose

### Prerequisites

- Docker
- Docker Compose

### Quick Start

1. Clone or download this repository
2. Navigate to the project directory
3. Run the application:

```bash
docker-compose up --build
```

4. Access the application at http://localhost:5001

### Stopping the Application

To stop the application, press `Ctrl+C` in the terminal where it's running, or run:

```bash
docker-compose down
```

### Development vs Production

The application uses SQLite for development and PostgreSQL for production. When running with Docker Compose, it will use PostgreSQL by default.

To run in development mode with SQLite:

```bash
python app.py
```

## Project Structure

```
pyweb/
├── app.py              # Main Flask application
├── requirements.txt    # Python dependencies
├── Dockerfile          # Docker configuration
├── docker-compose.yml  # Docker Compose configuration
├── .dockerignore       # Files to exclude from Docker build
├── templates/          # HTML templates
│   ├── base.html       # Base template
│   ├── index.html      # Homepage
│   ├── login.html      # Login page
│   ├── register.html   # Registration page
│   ├── dashboard.html  # User dashboard
│   ├── notebook_form.html  # Notebook creation/editing
│   ├── view_notebook.html  # Notebook viewing
│   ├── embed_notebook.html # Embedded notebook view
│   └── embed_code.html # Embed code generation
└── instance/
    └── app.db          # SQLite database (development only)
```

## Configuration

### Environment Variables

- `FLASK_ENV`: Set to "production" to use PostgreSQL
- `DATABASE_URL`: PostgreSQL connection string (defaults to docker-compose settings)

## Security

- Each code snippet runs in an isolated virtual environment
- User passwords are hashed using Werkzeug security
- Sessions are managed with Flask-Login
- Input validation and error handling

## Technologies Used

- Flask (Python web framework)
- SQLAlchemy (ORM)
- PostgreSQL (production database)
- SQLite (development database)
- Bootstrap 5 (frontend framework)
- CodeMirror (code editor)
- Docker & Docker Compose (containerization)

## License

This project is licensed under the MIT License.